'************************************ INIT *************************************

Dim FSO					' This is needed for file-operations

On Error Resume Next			' If you disable this, you will get an
					' error-message on empty directories.

'Preferences
'Name of RAS-conn;        "" = disable dialing
Const RASDIAL_CONNECTION     = "Ras Connection"

'Username for RAS-conn;   "" = use Hamster-setting
Const RASDIAL_USERNAME       = "User Name"

'Password for RAS-conn;   "" = use Hamster-setting
Const RASDIAL_PASSWORD       = "Passwort"

Const PURGE_BEFORE_TRANSFER  = False			'True  = enable purging
							'False = disable purging

'Initialize Hamster-constants
Const HAM_PURGEOPT_DOALL     = &HF			'Purge All
Const HAM_PURGEOPT_DONEWS    = &H1			'Purge News
Const HAM_PURGEOPT_DOHISTORY = &H2			'Purge History
Const HAM_PURGEOPT_DOKILLS   = &H4			'Purge Kills
Const HAM_WAITIDLE_INFINITE  = 0



' Initialize Hamster-object
' Note: Hamster.exe will be loaded now if does not run already.
Set Hamster = Wscript.CreateObject( "Hamster.App" )

' Initialize FileSystemObject
Set FSO = CreateObject("Scripting.FileSystemObject")


'*********************************** PURGE ************************************

'Select the method of purging by removing one of the four comment marks (')

If PURGE_BEFORE_TRANSFER Then
   Hamster.ControlWaitIdle HAM_WAITIDLE_INFINITE

'   Hamster.ControlRunPurge HAM_PURGEOPT_DOALL      
'   Hamster.ControlRunPurge HAM_PURGEOPT_DONEWS   
'   Hamster.ControlRunPurge HAM_PURGEOPT_DOHISTORY
'   Hamster.ControlRunPurge HAM_PURGEOPT_DOKILLS  

End If


'************************ MAKE BACKUP OF OUTGOING MAILS ************************

'You may wish to adapt the path-settings to your individual needs

Hamster.ControlWaitIdle HAM_WAITIDLE_INFINITE
FSO.CopyFile "C:\Hamster\Mails\Mail.Out\*.*", "D:\Mail-Backup\Outgoing"


'********************************** RAS-DIAL ***********************************

'These lines will try to build up a RAS-dial-connection to your provider. If all
'tries fail, the script will be terminated.

Online = False
HowOften=0
DO UNTIL (Online = True) OR (HowOften >= 12)
  Online = Hamster.RasDial( RASDIAL_CONNECTION, RASDIAL_USERNAME, RASDIAL_PASSWORD )
   IF NOT Online Then
     HowOften = HowOften + 1
  End IF
LOOP

IF HowOften >=12 THEN
  WScript.Quit
End If


'***************************** COLLECT EVERYTHING ******************************

'MAIL
'====
'This example shows how to collect mail from three accounts and relay it to two
'local accounts. Of course you must change the settings to your provider,
'password, etc.

Hamster.ControlRunFetchMail "pop.aaa.net", "pop3", "Account1", "Password1", "User1"
Hamster.ControlRunFetchMail "pop.bbb.net", "pop3", "Account2", "Password2", "User1"
Hamster.ControlRunFetchMail "pop.ccc.net", "pop3", "Account3", "Password3", "User2"

'NEWS
'====
'This will post and pull Messages from all Newsgroups and Servers you have selected
'in "Hamster".

'News Posts
Hamster.ControlRunNewsPost ""

'News Pulls
Hamster.ControlRunNewsPull ""


Hamster.ControlWaitIdle HAM_WAITIDLE_INFINITE


'********************************* SEND MAILS **********************************

'The following lines will send outgoing mail to the SMTP-Accounts corresponding
'to the POP-Accounts above. Of courese, you must enter your individual settings
'here, too.

Hamster.ControlRunSendMail "mail.aaa.net", "smtp", "User1@aaa.net"
Hamster.ControlRunSendMail "mail.bbb.net", "smtp", "User1@bbb.net"
Hamster.ControlRunSendMail "mail.ccc.net", "smtp", "User2@ccc.net"


'*********************** DISCONNECT RAS-DIAL CONNECTION ************************

Hamster.RasHangup


'************************* MAKE BACKUP OF INCOMING MAILS ***********************

'Again, you should adapt the path-settings.

FSO.CopyFile "C:\Hamster\Mails\User1\*.*", "D:\Mail-Backup\Incoming\User1"
FSO.CopyFile "C:\Hamster\Mails\User2\*.*", "D:\Mail-Backup\Incoming\User2"


'************************************ EXIT *************************************

'Release Hamster-object
Wscript.DisconnectObject Hamster
